#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Thu Jul 19 14:54:51 2018

@author: melot
"""
import numpy as np

from scipy import ndimage as ndim
#on charge l'image de lena à l'aide de la fonction imread de la bibliothèque ndimage de scipy
y =ndim.imread("barb.bmp")
#on ne garde que la première composante car niveau de gris
y=y[:,:];
#l'image est de type int on la cast en double pour pouvoir faire des calculs
y=y.astype(float)


y=y/255;
#la taille de l'image peut s'obtenir à l'aide de l'attribut shape
[n1,n2]=y.shape

import matplotlib.pyplot as plt

plt.close('all')

plt.close('all')
#on affiche l'image à l'aide de la fonction imshow de la bibliothèque pyplot de matplotlib
#on donne un numero à la figure
plt.figure(1)
#on l'affiche en niveau de gris
plt.imshow(y, cmap="gray")
#on affiche la colorbar associée
plt.colorbar()
#on lui donne un titre
plt.title('Image originale')
#on affiche tout cela sur la figure 1
plt.show()

plt.figure(11)
#on l'affiche avec un autre code couleur
plt.imshow(y, cmap="jet")
#on affiche la colorbar associée
plt.colorbar()
#on lui donne un titre
plt.title('Image originale')
#on affiche tout cela sur la figure 1
plt.show()

plt.figure(2)
u=np.reshape(y,n1*n2,1)
plt.plot(u)
plt.title('valeurs prises par les pixels')
plt.show()

plt.figure(3)
plt.hist(u, bins=50)
plt.title('Histogramme des valeurs prises par les pixels')
plt.show()

# on charge la librairie ondelettes
import pywt

# on calcule l'ondelette de base
wavelet = pywt.Wavelet('db2')

#on calcule les coefficients de decomposition dans la base d'ondelette
coeffs = pywt.wavedec2(y, wavelet, mode = "periodization", level = 3)

arr, sli = pywt.coeffs_to_array(coeffs)

arrn=arr/np.max(np.abs(arr))
ucoeffs=np.reshape(arrn,n1*n2,1)

plt.figure(4)
plt.plot(ucoeffs)
plt.title('valeurs prises par les coefficients')

plt.figure(5)
plt.hist(np.abs(ucoeffs), bins=50)
plt.title('histogramme des coefficients en ondelettes')
plt.show()

