#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Thu Oct 25 10:39:36 2018

@author: melot
"""

import numpy as np
import numpy.fft as npfft
import numpy.linalg as npl

def creatematrixCaFo(N):
    """Crée la matrice d'un dictionnaire D de taille 2N*N qui est la concaténation 
    de la base canonique et de la base de Fourier orthonormale

    Entrée :

    N -- taille des bases considérées

    Sortie:
        
    D -- matrice du dictionnaire.

    """
    F=np.zeros((N,N),dtype='complex')
    for i in np.arange(0,N):
        u=np.zeros(N,dtype='complex')
        u[i]=np.sqrt(N)  
        e=npfft.ifft(u)
        e=e/npl.norm(e)
        #e=np.reshape(e,(N,))
        F[:,i]=e
    D=np.concatenate((np.eye(N),F),axis=1)
    return D



