ld
# coding: utf-8

# On importe les bibliotheques dont on va se servir

# In[1]:


import numpy as np
import matplotlib.pyplot as plt


# On commence par tracer un signal $x$ de taille $512$ 

# In[2]:


x= np.loadtxt('signal.txt')
x=np.array(x)
N=x.size

plt.figure()
plt.plot(x)
plt.show()


#  On calcule la transformee de Fourier discrète du signal

# In[3]:


xchap=np.fft.fft(x)


# On regarde le resultat. La transformee est complexe ! Il faut donc visualiser le module ou la partie réelle des coefficients. 

# In[4]:


plt.figure()
plt.plot(np.abs(xchap))
plt.show()


# On centre les fréquences en $0$.

# In[5]:


plt.figure()
plt.plot(np.arange(-N//2,N//2),np.fft.fftshift(np.abs(xchap)))
plt.show()


# On zoome sur les coefficients autour de $0$

# In[6]:


n0=30
Xchap=xchap.copy()
plt.figure()
Xchap=np.fft.fftshift(np.abs(Xchap))
plt.plot(np.arange(-n0,n0),Xchap[N//2-n0:N//2+n0],'rs')
plt.vlines(np.arange(-n0,n0),[0],Xchap[N//2-n0:N//2+n0])
plt.title('2*'+str(n0)+' premiers coefficients de Fourier')
plt.show()


# On fixe maintenant $M$ tel que $0\leq M\leq N/2-1$ et on définit la réponse impulsionnelle d'un filtre notée $h^M$ tel que
# <ul>
# <li> $\widehat{h^M}_\overline{k}=0$ si $|k|> M$</li>
# <li> $\widehat{h^M}_{\overline{k}}=1$ si $|k|\leq M$</li>
# </ul>
# 
# Appliquer ce filtre sur un signal $x$ revient à ne garder que les $M$ premiers coefficients $\langle x,e^n\rangle$, $n=-M,..,M$ et à mettre à zéro les autres. On calcule donc $$x^M=K_{h^M}(x)=\frac{1}{N}\sum\limits_{n=-M}^M \langle x,e^n\rangle e^n=\frac{1}{N}\sum\limits_{n=-M}^M \hat{x}_n e^n$$
# 
# Commençons à voir ce qui se passe pour $M=2^4$.
# 

# In[7]:


